<?php
/**
 * Plugin support: Elementor ( Define class to create our modules (widgets) )
 *
 * @package ThemeREX Addons
 * @since v1.0
 */

// Don't load directly
if ( ! defined( 'TRX_ADDONS_VERSION' ) ) {
	exit;
}

if (class_exists('\Elementor\Widget_Base') && !class_exists('TRX_Addons_Elementor_Widget')) {
	
	abstract class TRX_Addons_Elementor_Widget extends \Elementor\Widget_Base {
		
		// List of shortcodes params,
		// that must be plain and get its value from the elementor's array
		// 'param_name' => [ 'array_key' ]
		private $plain_params = array(
				'url' => 'url',
				'link' => 'url',
				'image' => 'url',
				'bg_image' => 'url',
				'columns' => 'size',
				'count' => 'size',
				'offset' => 'size',
				'slides_space' => 'size',
				'gradient_direction' => 'size',
		);
		
		// Set shortcode-specific list of params,
		// that must bubble up to the plain value
		protected function set_plain_params($list) {
			$this->plain_params = $list;
		}
		
		// Add shortcode-specific list of params,
		// that must bubble up to the plain value
		protected function add_plain_params($list) {
			$this->plain_params = array_merge($this->plain_params, $list);
		}
		
		// Return string with default subtitle
		protected function get_default_subtitle() {
			return __('Subtitle', 'trx_addons');
		}
		
		// Return string with default description
		protected function get_default_description() {
			return __('Some description text for this item', 'trx_addons');
		}
		
		/**
		 * Retrieve the list of scripts the widget depended on.
		 *
		 * Used to set scripts dependencies required to run the widget.
		 *
		 * @since 1.6.41
		 *
		 * @access public
		 *
		 * @return array Widget scripts dependencies.
		 */
		public function get_script_depends() {
			return array( 'trx_addons-elementor-preview' );
		}
		
		// Get all elements from specified post
		protected function get_post_elements($post_id = 0) {
			$meta = array();
			if ($post_id == 0 && trx_addons_get_value_gp('action')=='elementor')
				$post_id = trx_addons_get_value_gp('post');
			if ($post_id > 0) {
				$meta = get_post_meta( $post_id, '_elementor_data', true );
				if (substr($meta, 0, 1) == '[')
					$meta = json_decode( $meta, true );
			}
			return $meta;
		}
		
		// Get sc params from the current post or from the specified _elementor_data (2-nd parameter)
		protected function get_sc_params($sc='', $meta=false) {
			if ($meta === false)
				$meta = $this->get_post_elements();
			if (empty($sc))
				$sc = $this->get_name();
			$params = false;
			if (is_array($meta)) {
				foreach($meta as $v) {
					if (!empty($v['widgetType']) && $v['widgetType'] == $sc) {
						$params = $v['settings'];
						break;
					} else if (!empty($v['elements']) && count($v['elements']) > 0) {
						$params = $this->get_sc_params($sc, $v['elements']);
						if ($params !== false)
							break;
					}
				}
			}
			return $params;
		}
		
		// Return shortcode's name
		function get_sc_name() {
			return $this->get_name();
		}
		
		// Return shortcode function's name
		function get_sc_function() {
			return sprintf("trx_addons_%s", str_replace(array('trx_sc_', 'trx_widget_'), array('sc_', 'sc_widget_'), $this->get_sc_name()));
		}
		
		
		// ADD CONTROLS FOR COMMON PARAMETERS
		// Attention! You can use next tabs to create sections inside:
		// TAB_CONTENT | TAB_STYLE | TAB_ADVANCED | TAB_RESPONSIVE | TAB_LAYOUT | TAB_SETTINGS
		//------------------------------------------------------------
		
		// Create section with controls from params array
		protected function add_common_controls($group, $params, $add_params) {
			if (!empty($group['label'])) {
				$this->start_controls_section(
						'section_'.$group['section'].'_params',
						array(
								'label' => $group['label'],
								'tab' => empty($group['tab'])
										? \Elementor\Controls_Manager::TAB_CONTENT
										: $group['tab']
						)
				);
			}
			foreach ($params as $param) {
				if (isset($add_params[$param['name']])) {
					if (empty($add_params[$param['name']]))
						continue;
					else
						$param = array_merge($param, $add_params[$param['name']]);
					unset($add_params[$param['name']]);
				}
				$this->add_control($param['name'], $param);
			}
			if (count($add_params) > 0) {
				foreach ($add_params as $k => $v) {
					if (!empty($v) && is_array($v))
						$this->add_control($k, $v);
				}
			}
			if (!empty($group['label'])) {
				$this->end_controls_section();
			}
		}
		
		// Return parameters of the control with icons selector
		protected function get_icon_param($only_socials=false, $style='') {
			if (trx_addons_get_setting('icons_selector') == 'vc') {
				$params = array(
						array(
								'name' => 'icon',
								'type' => \Elementor\Controls_Manager::ICON,
								'label' => __( 'Icon', 'trx_addons' ),
								'label_block' => false,
								'default' => '',
						)
				);
			} else {
				if (empty($style)) {
					$style = $only_socials ? trx_addons_get_setting('socials_type') : trx_addons_get_setting('icons_type');
				}
				$params = array(
						array(
								'name' => 'icon',
								'type' => 'trx_icons',
								'label' => __( 'Icon', 'trx_addons' ),
								'label_block' => false,
								'default' => '',
								'options' => trx_addons_get_list_icons($style),
								'style' => $style
						)
				);
			}
			return apply_filters('trx_addons_filter_elementor_add_icon_param', $params, $only_socials, $style);
		}
		
		// Create control with icons selector
		protected function add_icon_param($group='', $add_params=array(), $style='') {
			$this->add_common_controls(
					array(
							'label' => $group===false ? __('Icon', 'trx_addons') : $group,
							'section' => 'icon'
					),
					$this->get_icon_param(!empty($add_params['only_socials']), $style),
					$add_params
			);
		}
		
		// Return 'Slider' parameters
		protected function get_slider_param() {
			$params = array(
					array(
							"name" => "slider",
							'type' => \Elementor\Controls_Manager::SWITCHER,
							"label" => __("Slider", 'trx_addons'),
							'label_off' => __( 'Off', 'trx_addons' ),
							'label_on' => __( 'On', 'trx_addons' ),
							'return_value' => '1'
					),
					array(
							"name" => "slides_space",
							'type' => \Elementor\Controls_Manager::SLIDER,
							"label" => __('Space', 'trx_addons'),
							"description" => wp_kses_data( __('Space between slides', 'trx_addons') ),
							'condition' => array(
									'slider' => '1',
							),
							'default' => array(
									'size' => 0
							),
							'range' => array(
									'px' => array(
											'min' => 0,
											'max' => 100
									)
							)
					),
					array(
							'name' => 'slider_controls',
							'type' => \Elementor\Controls_Manager::SELECT,
							'label' => __( 'Slider controls', 'trx_addons' ),
							'label_block' => false,
							'options' => trx_addons_get_list_sc_slider_controls(),
							'condition' => array(
									'slider' => '1',
							),
							'default' => 'none',
					),
					array(
							'name' => 'slider_pagination',
							'type' => \Elementor\Controls_Manager::SELECT,
							'label' => __( 'Slider pagination', 'trx_addons' ),
							'label_block' => false,
							'options' => trx_addons_get_list_sc_slider_paginations(),
							'condition' => array(
									'slider' => '1',
							),
							'default' => 'none',
					),
					array(
							"name" => "slides_centered",
							'type' => \Elementor\Controls_Manager::SWITCHER,
							"label" => __("Slides centered", 'trx_addons'),
							'label_off' => __( 'Off', 'trx_addons' ),
							'label_on' => __( 'On', 'trx_addons' ),
							'return_value' => '1',
							'condition' => array(
									'slider' => '1',
							),
					),
					array(
							"name" => "slides_overflow",
							'type' => \Elementor\Controls_Manager::SWITCHER,
							"label" => __("Slides overflow visible", 'trx_addons'),
							'label_off' => __( 'Off', 'trx_addons' ),
							'label_on' => __( 'On', 'trx_addons' ),
							'return_value' => '1',
							'condition' => array(
									'slider' => '1',
							),
					),
					array(
							"name" => "slider_mouse_wheel",
							'type' => \Elementor\Controls_Manager::SWITCHER,
							"label" => __("Mouse wheel enabled", 'trx_addons'),
							'label_off' => __( 'Off', 'trx_addons' ),
							'label_on' => __( 'On', 'trx_addons' ),
							'return_value' => '1',
							'condition' => array(
									'slider' => '1',
							),
					),
					array(
							"name" => "slider_autoplay",
							'type' => \Elementor\Controls_Manager::SWITCHER,
							"label" => __("Enable autoplay", 'trx_addons'),
							'label_off' => __( 'Off', 'trx_addons' ),
							'label_on' => __( 'On', 'trx_addons' ),
							'default' => '1',
							'return_value' => '1',
							'condition' => array(
									'slider' => '1',
							),
					),
			);
			return apply_filters('trx_addons_filter_elementor_add_slider_param', $params);
		}
		
		// Create controls with 'Slider' params
		protected function add_slider_param($group=false, $add_params=array()) {
			$this->add_common_controls(
					array(
							'label' => $group===false ? __('Slider', 'trx_addons') : $group,
							'section' => 'slider',
							'tab' => \Elementor\Controls_Manager::TAB_LAYOUT
					),
					$this->get_slider_param(),
					$add_params
			);
		}
		
		// Return 'Title' parameters
		protected function get_title_param($button=true) {
			$params = array(
					array(
							'name' => 'title_style',
							'type' => \Elementor\Controls_Manager::SELECT,
							'label' => __( 'Title style', 'trx_addons' ),
							'label_block' => false,
							'options' => apply_filters('trx_addons_sc_type', trx_addons_components_get_allowed_layouts('sc', 'title'), 'trx_sc_title'),
							'default' => 'default',
					),
					array(
							'name' => 'title_tag',
							'type' => \Elementor\Controls_Manager::SELECT,
							'label' => __( 'Title tag', 'trx_addons' ),
							'label_block' => false,
							'options' => trx_addons_get_list_sc_title_tags(),
							'default' => 'none',
					),
					array(
							'name' => 'title_align',
							'type' => \Elementor\Controls_Manager::SELECT,
							'label' => __( 'Title alignment', 'trx_addons' ),
							'label_block' => false,
							'options' => trx_addons_get_list_sc_aligns(),
							'default' => 'none',
					),
					array(
							'name' => 'title_color',
							'label' => __( 'Title color', 'trx_addons' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'default' => '',
							'description' => '',
					),
					array(
							'name' => 'title_color2',
							'label' => __( 'Title color 2', 'trx_addons' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'default' => '',
							'description' => '',
							'condition' => array(
									'title_style' => 'gradient'
							),
					),
					array(
							'name' => 'gradient_direction',
							'label' => __( 'Gradient direction', 'trx_addons' ),
							'type' => \Elementor\Controls_Manager::SLIDER,
							'default' => array(
									'size' => 0,
									'unit' => 'px'
							),
							'size_units' => array( 'px' ),
							'range' => array(
									'px' => array(
											'min' => 0,
											'max' => 360
									)
							),
							'condition' => array(
									'title_style' => 'gradient'
							),
					),
					array(
							'name' => 'title',
							'type' => \Elementor\Controls_Manager::TEXT,
							'label' => __( "Title", 'trx_addons' ),
							"description" => wp_kses_data( __("Title of the block. Enclose any words in {{ and }} to make them italic or in (( and )) to make them bold. If title style is 'accent' - bolded element styled as shadow, italic - as a filled circle", 'trx_addons') ),
							'placeholder' => __( "Title", 'trx_addons' ),
							'default' => ''
					),
					array(
							'name' => 'subtitle',
							'type' => \Elementor\Controls_Manager::TEXT,
							'label' => __( "Subtitle", 'trx_addons' ),
							'placeholder' => __( "Title text", 'trx_addons' ),
							'default' => ''
					),
					array(
							'name' => 'subtitle_align',
							'type' => \Elementor\Controls_Manager::SELECT,
							'label' => __( 'Subtitle alignment', 'trx_addons' ),
							'label_block' => false,
							'options' => trx_addons_get_list_sc_aligns(),
							'default' => 'none',
					),
					array(
							'name' => 'subtitle_position',
							'type' => \Elementor\Controls_Manager::SELECT,
							'label' => __( 'Subtitle position', 'trx_addons' ),
							'label_block' => false,
							'options' => trx_addons_get_list_sc_subtitle_positions(),
							'default' => trx_addons_get_setting('subtitle_above_title') ? 'above' : 'below',
					),
					array(
							'name' => 'description',
							'type' => \Elementor\Controls_Manager::TEXTAREA,
							'label' => __( 'Description', 'trx_addons' ),
							'label_block' => true,
							'placeholder' => __( "Short description of this block", 'trx_addons' ),
							'default' => '',
							'separator' => 'none',
							'rows' => 10,
							'show_label' => false,
					)
			);
			// Add button's params
			if ($button) {
				$params[] = array(
						'name' => 'link',
						'type' => \Elementor\Controls_Manager::URL,
						'label' => __( "Button's Link", 'trx_addons' ),
						'label_block' => false,
						'placeholder' => __( 'http://your-link.com', 'trx_addons' ),
				);
				$params[] = array(
						'name' => 'link_text',
						'type' => \Elementor\Controls_Manager::TEXT,
						'label' => __( "Button's text", 'trx_addons' ),
						'label_block' => false,
						'placeholder' => __( "Link's text", 'trx_addons' ),
						'default' => ''
				);
				$params[] = array(
						'name' => 'link_style',
						'type' => \Elementor\Controls_Manager::SELECT,
						'label' => __( "Button's style", 'trx_addons' ),
						'label_block' => false,
						'options' => apply_filters('trx_addons_sc_type', trx_addons_components_get_allowed_layouts('sc', 'button'), 'trx_sc_button'),
						'default' => 'default',
				);
				$params[] = array(
						'name' => 'link_image',
						'type' => \Elementor\Controls_Manager::MEDIA,
						'label' => __( "Button's image", 'trx_addons' ),
						'default' => array(
								'url' => '',
						),
				);
			}
			return apply_filters('trx_addons_filter_elementor_add_title_param', $params);
		}
		
		// Create controls with 'Title' params
		protected function add_title_param($group=false, $add_params=array()) {
			$this->add_common_controls(
					array(
							'label' => $group===false ? __('Title, Description & Button', 'trx_addons') : $group,
							'section' => 'title',
							'tab' => \Elementor\Controls_Manager::TAB_LAYOUT
					),
					$this->get_title_param(!isset($add_params['button']) || $add_params['button']),
					$add_params
			);
		}
		
		// Return 'Query' parameters
		protected function get_query_param() {
			$params = array(
					array(
							'name' => 'ids',
							'type' => \Elementor\Controls_Manager::TEXT,
							'label' => __( "IDs to show", 'trx_addons' ),
							"description" => wp_kses_data( __("Comma separated IDs list to show. If not empty - parameters 'cat', 'offset' and 'count' are ignored!", 'trx_addons') ),
							'placeholder' => __( "IDs list", 'trx_addons' ),
							'default' => ''
					),
					array(
							"name" => "count",
							'type' => \Elementor\Controls_Manager::SLIDER,
							"label" => __('Count', 'trx_addons'),
							'condition' => array(
									'ids' => '',
							),
							'default' => array(
									'size' => 3
							),
							'range' => array(
									'px' => array(
											'min' => 1,
											'max' => 100
									)
							)
					),
					array(
							"name" => "columns",
							'type' => \Elementor\Controls_Manager::SLIDER,
							"label" => __('Columns', 'trx_addons'),
							"description" => wp_kses_data( __("Specify number of columns. If empty - auto detect by items number", 'trx_addons') ),
							'default' => array(
									'size' => 0
							),
							'range' => array(
									'px' => array(
											'min' => 0,
											'max' => 12
									)
							)
					),
					array(
							"name" => "offset",
							'type' => \Elementor\Controls_Manager::SLIDER,
							"label" => __('Offset', 'trx_addons'),
							"description" => wp_kses_data( __("Specify number of items to skip before showed items", 'trx_addons') ),
							'condition' => array(
									'ids' => '',
							),
							'default' => array(
									'size' => 0
							),
							'range' => array(
									'px' => array(
											'min' => 0,
											'max' => 100
									)
							)
					),
					array(
							'name' => 'orderby',
							'type' => \Elementor\Controls_Manager::SELECT,
							'label' => __( 'Order by', 'trx_addons' ),
							'label_block' => false,
							'options' => trx_addons_get_list_sc_query_orderby(),
							'default' => 'none',
					),
					array(
							'name' => 'order',
							'type' => \Elementor\Controls_Manager::SELECT,
							'label' => __( 'Order', 'trx_addons' ),
							'label_block' => false,
							'options' => trx_addons_get_list_sc_query_orders(),
							'default' => 'asc',
					)
			);
			return apply_filters('trx_addons_filter_elementor_add_query_param', $params);
		}
		
		// Create controls with 'Query' params
		protected function add_query_param($group=false, $add_params=array()) {
			$this->add_common_controls(
					array(
							'label' => $group===false ? __('Query', 'trx_addons') : $group,
							'section' => 'query'
					),
					$this->get_query_param(),
					$add_params
			);
		}
		
		// Return 'Hide' parameters
		static function get_hide_param($hide_on_frontpage=false) {
			$params = array(
					array(
							'name' => 'hide_on_wide',
							'type' => \Elementor\Controls_Manager::SWITCHER,
							'label' => __( 'Hide on wide screens', 'trx_addons' ),
							'label_off' => __( 'Off', 'trx_addons' ),
							'label_on' => __( 'On', 'trx_addons' ),
							'return_value' => '1'
					),
					array(
							'name' => 'hide_on_desktop',
							'type' => \Elementor\Controls_Manager::SWITCHER,
							'label' => __( 'Hide on desktops', 'trx_addons' ),
							'label_off' => __( 'Off', 'trx_addons' ),
							'label_on' => __( 'On', 'trx_addons' ),
							'return_value' => '1'
					),
					array(
							'name' => 'hide_on_notebook',
							'type' => \Elementor\Controls_Manager::SWITCHER,
							'label' => __( 'Hide on notebooks', 'trx_addons' ),
							'label_off' => __( 'Off', 'trx_addons' ),
							'label_on' => __( 'On', 'trx_addons' ),
							'return_value' => '1'
					),
					array(
							'name' => 'hide_on_tablet',
							'type' => \Elementor\Controls_Manager::SWITCHER,
							'label' => __( 'Hide on tablets', 'trx_addons' ),
							'label_off' => __( 'Off', 'trx_addons' ),
							'label_on' => __( 'On', 'trx_addons' ),
							'return_value' => '1'
					),
					array(
							'name' => 'hide_on_mobile',
							'type' => \Elementor\Controls_Manager::SWITCHER,
							'label' => __( 'Hide on mobile devices', 'trx_addons' ),
							'label_off' => __( 'Off', 'trx_addons' ),
							'label_on' => __( 'On', 'trx_addons' ),
							'return_value' => '1'
					)
			);
			if ($hide_on_frontpage) {
				$params[] = array(
						'name' => 'hide_on_frontpage',
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'label' => __( 'Hide on Frontpage', 'trx_addons' ),
						'label_off' => __( 'Off', 'trx_addons' ),
						'label_on' => __( 'On', 'trx_addons' ),
						'return_value' => '1'
				);
				$params[] = array(
						'name' => 'hide_on_singular',
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'label' => __( 'Hide on single posts', 'trx_addons' ),
						'label_off' => __( 'Off', 'trx_addons' ),
						'label_on' => __( 'On', 'trx_addons' ),
						'return_value' => '1'
				);
				$params[] = array(
						'name' => 'hide_on_other',
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'label' => __( 'Hide on other pages', 'trx_addons' ),
						'label_off' => __( 'Off', 'trx_addons' ),
						'label_on' => __( 'On', 'trx_addons' ),
						'return_value' => '1'
				);
			}
			return apply_filters('trx_addons_filter_elementor_add_hide_param', $params);
		}
		
		// Create controls with 'Hide' params
		protected function add_hide_param($group=false, $add_params=array()) {
			$this->add_common_controls(
					array(
							'label' => $group===false ? __('Hide', 'trx_addons') : $group,
							'section' => 'hide',
							'tab' => \Elementor\Controls_Manager::TAB_LAYOUT
					),
					$this->get_hide_param(!empty($add_params['hide_on_frontpage'])),
					$add_params
			);
		}
		
		
		// RENDER SHORTCODE'S CONTENT
		//------------------------------------------------------------
		
		// Return widget's layout
		public function render() {
			$sc_func = $this->get_sc_function();
			if (function_exists($sc_func)) {
				trx_addons_sc_stack_push('trx_sc_layouts');		// To prevent wrap shortcodes output to the '<div class="sc_layouts_item"></div>'
				$output = call_user_func($sc_func, $this->sc_prepare_atts($this->get_settings(), $this->get_sc_name()));
				trx_addons_sc_stack_pop();
				trx_addons_show_layout($output);
			}
		}
		
		// Show message (placeholder) about not existing shortcode
		public function shortcode_not_exists($sc, $plugin) {
			?><div class="trx_addons_sc_not_exists">
			<h5 class="trx_addons_sc_not_exists_title"><?php echo esc_html(sprintf(__('Shortcode %s is not available!', 'trx_addons'), $sc)); ?></h5>
			<div class="trx_addons_sc_not_exists_description">
				<p><?php echo esc_html(sprintf(__('Shortcode "%1$s" from plugin "%2$s" is not available in Elementor Editor!', 'trx_addons'), $sc, $plugin)); ?></p>
				<p><?php esc_html_e('Possible causes:', 'trx_addons'); ?></p>
				<ol class="trx_addons_sc_not_exists_causes">
					<li><?php echo esc_html(sprintf(__('Plugin "%s" is not installed or not active', 'trx_addons'), $plugin)); ?></li>
					<li><?php esc_html_e('The plugin registers a shortcode later than it asks for Elementor Editor', 'trx_addons'); ?></li>
				</ol>
				<p><?php esc_html_e("So in the editor instead of the shortcode you see this message. To see the real shortcode's output - save the changes and open this page in Frontend", 'trx_addons'); ?></p>
			</div>
			</div><?php
		}
		
		// Prepare params for our shortcodes
		protected function sc_prepare_atts($atts, $sc='', $level=0) {
			if (is_array($atts)) {
				foreach($atts as $k=>$v) {
					// If current element is group (repeater)
					if (is_array($v) && isset($v[0]) && is_array($v[0])) {
						foreach ($v as $k1=>$v1) {
							$atts[$k][$k1] = $this->sc_prepare_atts($v1, $sc, $level+1);
						}
						
						// Current element is single control
					} else {
						// Make 'xxx' as plain string
						// and add 'xxx_extra' for each plain param
						if (in_array($k, array_keys($this->plain_params))) {
							$prm = explode('+', $this->plain_params[$k]);
							$atts["{$k}_extra"] = $v;
							if (isset($v[$prm[0]]))
								$atts[$k] = $v = $v[$prm[0]] . (!empty($v[$prm[0]]) && !empty($prm[1]) && isset($v[$prm[1]]) ? $v[$prm[1]] : '');
						}
						// Sinchronize 'id' and '_element_id'
						if ($k == '_element_id') {
							if (empty($atts['id'])) {
								$atts['id'] = !empty($v)
										? $v . '_sc' // original '_element_id' is already applied to element's wrapper
										: $this->get_sc_name() . '_' . str_replace('.', '', mt_rand());
							}
							/*
															// Sinchronize 'class' and '_css_classes'
															// Not used, because 'class' is already applied to element's wrapper
															} else if ($k == '_css_classes') {
																if (empty($atts['class'])) $atts['class'] = $v;
							*/
							// Add icon_type='elementor' if attr 'icon' is present and equal to the 'fa fa-xxx'
						} else if ($k == 'icon' && trx_addons_is_elementor_icon($v)) {
							$atts['icon_type'] = 'elementor';
						}
					}
				}
			}
			return $level == 0 ? apply_filters('trx_addons_filter_elementor_sc_prepare_atts', $atts, $sc) : $atts;
		}
		
		
		// DISPLAY TEMPLATE'S PARTS
		//------------------------------------------------------------
		
		// Display title, subtitle and description for some shortcodes
		public function sc_show_titles($sc, $size='') {
			trx_addons_get_template_part('templates/tpe.sc_titles.php',
					'trx_addons_args_sc_show_titles',
					array('sc' => $sc, 'size' => $size, 'element' => $this)
			);
			
		}
		
		// Display link button or image for some shortcodes
		public function sc_show_links($sc) {
			trx_addons_get_template_part('templates/tpe.sc_links.php',
					'trx_addons_args_sc_show_links',
					array('sc' => $sc, 'element' => $this)
			);
		}
		
		// Display template from the shortcode 'Button'
		public function sc_show_button($sc) {
			?><#
			var settings_sc_button_old = settings;
			settings = {
			'title': settings.link_text,
			'link': settings.link,
			'type': settings.link_style,
			'class': 'sc_item_button sc_item_button_'+settings.link_style+' <?php echo esc_attr($sc); ?>_button',
			'align': settings.title_align ? settings.title_align : 'none'
			};
			#><?php
			trx_addons_get_template_part(TRX_ADDONS_PLUGIN_SHORTCODES . 'button/tpe.button.php',
					'trx_addons_args_sc_show_button',
					array('sc' => $sc, 'element' => $this)
			);
			?><#
			settings = settings_sc_button_old;
			#><?php
		}
		
		// Display begin of the slider layout for some shortcodes
		public function sc_show_slider_wrap_start($sc) {
			trx_addons_get_template_part('templates/tpe.sc_slider_start.php',
					'trx_addons_args_sc_show_slider_wrap',
					apply_filters('trx_addons_filter_sc_show_slider_args', array('sc' => $sc, 'element' => $this))
			);
		}
		
		// Display end of the slider layout for some shortcodes
		public function sc_show_slider_wrap_end($sc) {
			trx_addons_get_template_part('templates/tpe.sc_slider_end.php',
					'trx_addons_args_sc_show_slider_wrap',
					apply_filters('trx_addons_filter_sc_show_slider_args', array('sc' => $sc, 'element' => $this))
			);
		}
	}
}
